/*
 * Decompiled with CFR 0.152.
 */
package me.alphamode.star.client.renderers;

import java.util.function.Supplier;
import me.alphamode.star.client.models.FluidBakedModel;
import me.alphamode.star.client.models.UpsideDownFluidModel;
import me.alphamode.star.extensions.fabric.FluidRenderHandlerExtension;
import me.alphamode.star.world.fluids.DirectionalFluid;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerRegistryImpl;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2373;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import net.minecraft.class_775;
import org.jetbrains.annotations.Nullable;

public class UpsideDownFluidRenderer
implements FluidRenderHandler,
FluidRenderHandlerExtension {
    private final FluidBakedModel model;
    protected final Supplier<class_2960> stillGetter;
    protected final Supplier<class_2960> flowingGetter;
    protected final Supplier<class_2960> overlayGetter;
    protected final class_1058[] sprites;
    protected final int tint;

    public UpsideDownFluidRenderer(Supplier<class_2960> stillTexture, Supplier<class_2960> flowingTexture, Supplier<class_2960> overlayTexture, int tint) {
        this.stillGetter = stillTexture;
        this.flowingGetter = flowingTexture;
        this.overlayGetter = overlayTexture;
        this.sprites = new class_1058[overlayTexture == null ? 2 : 3];
        this.tint = tint;
        this.model = new UpsideDownFluidModel();
    }

    public UpsideDownFluidRenderer(class_2960 stillTexture, class_2960 flowingTexture, int tint) {
        this(() -> stillTexture, () -> flowingTexture, null, tint);
    }

    public UpsideDownFluidRenderer(class_2960 stillTexture, class_2960 flowingTexture, class_2960 overlayTexture) {
        this(() -> stillTexture, () -> flowingTexture, () -> overlayTexture, -1);
    }

    public UpsideDownFluidRenderer(class_2960 stillTexture, class_2960 flowingTexture) {
        this(() -> stillTexture, () -> flowingTexture, null, -1);
    }

    public UpsideDownFluidRenderer(int tint) {
        this(() -> SimpleFluidRenderHandler.WATER_STILL, () -> SimpleFluidRenderHandler.WATER_FLOWING, () -> SimpleFluidRenderHandler.WATER_OVERLAY, tint);
    }

    public UpsideDownFluidRenderer() {
        this(SimpleFluidRenderHandler.WATER_STILL, SimpleFluidRenderHandler.WATER_FLOWING, SimpleFluidRenderHandler.WATER_OVERLAY);
    }

    public class_1058[] getFluidSprites(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
        return this.sprites;
    }

    public void reloadTextures(class_1059 textureAtlas) {
        this.sprites[0] = textureAtlas.method_4608(this.stillGetter.get());
        this.sprites[1] = textureAtlas.method_4608(this.flowingGetter.get());
        if (this.overlayGetter != null) {
            this.sprites[2] = textureAtlas.method_4608(this.overlayGetter.get());
        }
    }

    public void renderFluid(class_2338 pos, class_1920 world, class_4588 vertexConsumer, class_2680 blockState, class_3610 fluidState) {
        DirectionalFluid fluid = (DirectionalFluid)fluidState.method_15772();
        if (fluid.getFlowDirection() == class_2350.field_11033) {
            ((FluidRenderHandlerRegistryImpl)FluidRenderHandlerRegistry.INSTANCE).renderFluid(pos, world, vertexConsumer, blockState, fluidState);
            return;
        }
        boolean isInLava = fluidState.method_15767(class_3486.field_15518);
        class_1058[] sprites = isInLava ? FluidRenderHandlerRegistry.INSTANCE.get((class_3611)class_3612.field_15908).getFluidSprites(world, pos, fluidState) : this.getFluidSprites(world, pos, fluidState);
        int fluidColor = this.getFluidColor(world, pos, fluidState);
        float r = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(fluidColor & 0xFF) / 255.0f;
        class_2680 downState = world.method_8320(pos.method_10093(class_2350.field_11033));
        class_3610 downFluidState = downState.method_26227();
        class_2680 upState = world.method_8320(pos.method_10093(class_2350.field_11036));
        class_3610 upFluidState = upState.method_26227();
        class_2680 northState = world.method_8320(pos.method_10093(class_2350.field_11043));
        class_3610 northFluidState = northState.method_26227();
        class_2680 southState = world.method_8320(pos.method_10093(class_2350.field_11035));
        class_3610 southFluidState = southState.method_26227();
        class_2680 westState = world.method_8320(pos.method_10093(class_2350.field_11039));
        class_3610 westFluidState = westState.method_26227();
        class_2680 eastState = world.method_8320(pos.method_10093(class_2350.field_11034));
        class_3610 eastFluidState = eastState.method_26227();
        boolean isFluidTheSame = !class_775.method_3348((class_3610)fluidState, (class_3610)downFluidState);
        boolean renderBottomSide = class_775.method_29708((class_1920)world, (class_2338)pos, (class_3610)fluidState, (class_2680)blockState, (class_2350)fluid.getFlowDirection(), (class_3610)upFluidState) && !UpsideDownFluidRenderer.isSideCovered((class_1922)world, pos, fluid.getFlowDirection(), 0.8888889f, upState);
        boolean renderNorthSide = class_775.method_29708((class_1920)world, (class_2338)pos, (class_3610)fluidState, (class_2680)blockState, (class_2350)class_2350.field_11043, (class_3610)northFluidState);
        boolean renderSouthSide = class_775.method_29708((class_1920)world, (class_2338)pos, (class_3610)fluidState, (class_2680)blockState, (class_2350)class_2350.field_11035, (class_3610)southFluidState);
        boolean renderWestSide = class_775.method_29708((class_1920)world, (class_2338)pos, (class_3610)fluidState, (class_2680)blockState, (class_2350)class_2350.field_11039, (class_3610)westFluidState);
        boolean renderEastSide = class_775.method_29708((class_1920)world, (class_2338)pos, (class_3610)fluidState, (class_2680)blockState, (class_2350)class_2350.field_11034, (class_3610)eastFluidState);
        if (isFluidTheSame || renderBottomSide || renderEastSide || renderWestSide || renderNorthSide || renderSouthSide) {
            float yOffset;
            float southWestHeight;
            float southEastHeight;
            float northWestHeight;
            float northEastHeight;
            float downBrightness = world.method_24852(class_2350.field_11033, true);
            float upBrightness = world.method_24852(class_2350.field_11036, true);
            float northBrightness = world.method_24852(class_2350.field_11043, true);
            float westBrightness = world.method_24852(class_2350.field_11039, true);
            float fluidHeight = UpsideDownFluidRenderer.getFluidHeight(world, fluid, pos, blockState, fluidState);
            if (fluidHeight >= 1.0f) {
                northEastHeight = 1.0f;
                northWestHeight = 1.0f;
                southEastHeight = 1.0f;
                southWestHeight = 1.0f;
            } else {
                float s = UpsideDownFluidRenderer.getFluidHeight(world, fluid, pos.method_10095(), northState, northFluidState);
                float t = UpsideDownFluidRenderer.getFluidHeight(world, fluid, pos.method_10072(), southState, southFluidState);
                float u = UpsideDownFluidRenderer.getFluidHeight(world, fluid, pos.method_10078(), eastState, eastFluidState);
                float v = UpsideDownFluidRenderer.getFluidHeight(world, fluid, pos.method_10067(), westState, westFluidState);
                northEastHeight = UpsideDownFluidRenderer.getHeightToRenderFluid(world, fluid, fluidHeight, s, u, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11034));
                northWestHeight = UpsideDownFluidRenderer.getHeightToRenderFluid(world, fluid, fluidHeight, s, v, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11039));
                southEastHeight = UpsideDownFluidRenderer.getHeightToRenderFluid(world, fluid, fluidHeight, t, u, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11034));
                southWestHeight = UpsideDownFluidRenderer.getHeightToRenderFluid(world, fluid, fluidHeight, t, v, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11039));
            }
            double chunkX = pos.method_10263() & 0xF;
            double chunkY = pos.method_10264() & 0xF;
            double chunkZ = pos.method_10260() & 0xF;
            float f = yOffset = renderBottomSide ? 0.001f : 0.0f;
            if (isFluidTheSame) {
                float ak;
                float aj;
                float ai;
                float ah;
                float ag;
                float af;
                float ae;
                float ad;
                float ac;
                float ab;
                float aa;
                float z;
                northWestHeight -= 0.001f;
                southWestHeight -= 0.001f;
                southEastHeight -= 0.001f;
                northEastHeight -= 0.001f;
                class_243 vec3d = fluidState.method_15758((class_1922)world, pos);
                if (vec3d.field_1352 == 0.0 && vec3d.field_1350 == 0.0) {
                    sprite = sprites[0];
                    z = sprite.method_4580(0.0);
                    aa = sprite.method_4570(0.0);
                    ab = z;
                    ac = sprite.method_4570(16.0);
                    ad = sprite.method_4580(16.0);
                    ae = ac;
                    af = ad;
                    ag = aa;
                } else {
                    sprite = sprites[1];
                    ah = (float)class_3532.method_15349((double)vec3d.field_1350, (double)vec3d.field_1352) - 1.5707964f;
                    ai = class_3532.method_15374((float)ah) * 0.25f;
                    aj = class_3532.method_15362((float)ah) * 0.25f;
                    ak = 8.0f;
                    z = sprite.method_4580((double)(8.0f + (-aj - ai) * 16.0f));
                    aa = sprite.method_4570((double)(8.0f + (-aj + ai) * 16.0f));
                    ab = sprite.method_4580((double)(8.0f + (-aj + ai) * 16.0f));
                    ac = sprite.method_4570((double)(8.0f + (aj + ai) * 16.0f));
                    ad = sprite.method_4580((double)(8.0f + (aj + ai) * 16.0f));
                    ae = sprite.method_4570((double)(8.0f + (aj - ai) * 16.0f));
                    af = sprite.method_4580((double)(8.0f + (aj - ai) * 16.0f));
                    ag = sprite.method_4570((double)(8.0f + (-aj - ai) * 16.0f));
                }
                float al = (z + ab + ad + af) / 4.0f;
                ah = (aa + ac + ae + ag) / 4.0f;
                ai = (float)sprites[0].method_45851().method_45807() / (sprites[0].method_4577() - sprites[0].method_4594());
                aj = (float)sprites[0].method_45851().method_45815() / (sprites[0].method_4575() - sprites[0].method_4593());
                ak = 4.0f / Math.max(aj, ai);
                z = class_3532.method_16439((float)ak, (float)z, (float)al);
                ab = class_3532.method_16439((float)ak, (float)ab, (float)al);
                ad = class_3532.method_16439((float)ak, (float)ad, (float)al);
                af = class_3532.method_16439((float)ak, (float)af, (float)al);
                aa = class_3532.method_16439((float)ak, (float)aa, (float)ah);
                ac = class_3532.method_16439((float)ak, (float)ac, (float)ah);
                ae = class_3532.method_16439((float)ak, (float)ae, (float)ah);
                ag = class_3532.method_16439((float)ak, (float)ag, (float)ah);
                int am = UpsideDownFluidRenderer.getLight(world, pos);
                float an = upBrightness * r;
                float ao = upBrightness * g;
                float ap = upBrightness * b;
                this.vertex(vertexConsumer, chunkX + 0.0, chunkY - (double)northWestHeight + 1.0, chunkZ + 0.0, an, ao, ap, z, aa, am);
                this.vertex(vertexConsumer, chunkX + 0.0, chunkY - (double)southWestHeight + 1.0, chunkZ + 1.0, an, ao, ap, ab, ac, am);
                this.vertex(vertexConsumer, chunkX + 1.0, chunkY - (double)southEastHeight + 1.0, chunkZ + 1.0, an, ao, ap, ad, ae, am);
                this.vertex(vertexConsumer, chunkX + 1.0, chunkY - (double)northEastHeight + 1.0, chunkZ + 0.0, an, ao, ap, af, ag, am);
                this.vertex(vertexConsumer, chunkX + 0.0, chunkY - (double)northWestHeight + 1.0, chunkZ + 0.0, an, ao, ap, z, aa, am);
                this.vertex(vertexConsumer, chunkX + 1.0, chunkY - (double)northEastHeight + 1.0, chunkZ + 0.0, an, ao, ap, af, ag, am);
                this.vertex(vertexConsumer, chunkX + 1.0, chunkY - (double)southEastHeight + 1.0, chunkZ + 1.0, an, ao, ap, ad, ae, am);
                this.vertex(vertexConsumer, chunkX + 0.0, chunkY - (double)southWestHeight + 1.0, chunkZ + 1.0, an, ao, ap, ab, ac, am);
            }
            if (renderBottomSide) {
                float z = sprites[0].method_4594();
                float ab = sprites[0].method_4577();
                float ad = sprites[0].method_4593();
                float af = sprites[0].method_4575();
                int aq = UpsideDownFluidRenderer.getLight(world, pos.method_10093(fluid.getFlowDirection()));
                float ac = downBrightness * r;
                float ae = downBrightness * g;
                float ag = downBrightness * b;
                this.vertex(vertexConsumer, chunkX + 1.0, chunkY + (double)yOffset + 1.0, chunkZ, ac, ae, ag, z, af, aq);
                this.vertex(vertexConsumer, chunkX, chunkY + (double)yOffset + 1.0, chunkZ, ac, ae, ag, ab, af, aq);
                this.vertex(vertexConsumer, chunkX, chunkY + (double)yOffset + 1.0, chunkZ + 1.0, ac, ae, ag, ab, ad, aq);
                this.vertex(vertexConsumer, chunkX + 1.0, chunkY + (double)yOffset + 1.0, chunkZ + 1.0, ac, ae, ag, z, ad, aq);
            }
            int light = UpsideDownFluidRenderer.getLight(world, pos);
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2248 block;
                double endZ;
                double startZ;
                double endX;
                double startX;
                float endSideY;
                float sideY;
                if (!(switch (direction) {
                    case class_2350.field_11043 -> {
                        sideY = northWestHeight;
                        endSideY = northEastHeight;
                        startX = chunkX;
                        endX = chunkX + 1.0;
                        startZ = chunkZ + (double)0.001f;
                        endZ = chunkZ + (double)0.001f;
                        yield renderNorthSide;
                    }
                    case class_2350.field_11035 -> {
                        sideY = southEastHeight;
                        endSideY = southWestHeight;
                        startX = chunkX + 1.0;
                        endX = chunkX;
                        startZ = chunkZ + 1.0 - (double)0.001f;
                        endZ = chunkZ + 1.0 - (double)0.001f;
                        yield renderSouthSide;
                    }
                    case class_2350.field_11039 -> {
                        sideY = southWestHeight;
                        endSideY = northWestHeight;
                        startX = chunkX + (double)0.001f;
                        endX = chunkX + (double)0.001f;
                        startZ = chunkZ + 1.0;
                        endZ = chunkZ;
                        yield renderWestSide;
                    }
                    default -> {
                        sideY = northEastHeight;
                        endSideY = southEastHeight;
                        startX = chunkX + 1.0 - (double)0.001f;
                        endX = chunkX + 1.0 - (double)0.001f;
                        startZ = chunkZ;
                        endZ = chunkZ + 1.0;
                        yield renderEastSide;
                    }
                }) || UpsideDownFluidRenderer.isSideCovered((class_1922)world, pos, direction, Math.max(sideY, endSideY), world.method_8320(pos.method_10093(direction)))) continue;
                class_2338 blockPos = pos.method_10093(direction);
                class_1058 sprite2 = sprites[1];
                if (!isInLava && ((block = world.method_8320(blockPos).method_26204()) instanceof class_2373 || block instanceof class_2397)) {
                    sprite2 = this.getFluidSprites(world, blockPos, fluidState)[2];
                }
                float startU = sprite2.method_4580(0.0);
                float endV = sprite2.method_4570((double)((1.0f - sideY) * 16.0f * 0.5f));
                float ap = sprite2.method_4580(8.0);
                float ax = sprite2.method_4570((double)((1.0f - endSideY) * 16.0f * 0.5f));
                float ay = sprite2.method_4570(8.0);
                float directionBrightness = direction.method_10166() == class_2350.class_2351.field_11051 ? northBrightness : westBrightness;
                float red = upBrightness * directionBrightness * r;
                float blue = upBrightness * directionBrightness * g;
                float green = upBrightness * directionBrightness * b;
                this.vertex(vertexConsumer, endX, chunkY + 1.0 - (double)endSideY, endZ, red, blue, green, ap, ax, light);
                this.vertex(vertexConsumer, startX, chunkY + 1.0 - (double)sideY, startZ, red, blue, green, startU, endV, light);
                this.vertex(vertexConsumer, startX, chunkY + 1.0 - (double)yOffset, startZ, red, blue, green, startU, ay, light);
                this.vertex(vertexConsumer, endX, chunkY + 1.0 - (double)yOffset, endZ, red, blue, green, ap, ay, light);
                if (this.getFluidSprites(world, blockPos, fluidState).length != 3 || sprite2 == this.getFluidSprites(world, blockPos, fluidState)[2]) continue;
                this.vertex(vertexConsumer, endX, chunkY + 1.0 - (double)yOffset, endZ, red, blue, green, startU, ay, light);
                this.vertex(vertexConsumer, startX, chunkY + 1.0 - (double)yOffset, startZ, red, blue, green, ap, ay, light);
                this.vertex(vertexConsumer, startX, chunkY + 1.0 - (double)sideY, startZ, red, blue, green, ap, ax, light);
                this.vertex(vertexConsumer, endX, chunkY + 1.0 - (double)endSideY, endZ, red, blue, green, startU, endV, light);
            }
        }
    }

    @Override
    public FluidBakedModel getFluidModel() {
        return this.model;
    }

    public static float getFluidHeight(class_1920 blockRenderView, DirectionalFluid fluid, class_2338 blockPos) {
        class_2680 blockState = blockRenderView.method_8320(blockPos);
        return UpsideDownFluidRenderer.getFluidHeight(blockRenderView, fluid, blockPos, blockState, blockState.method_26227());
    }

    public static float getHeightToRenderFluid(class_1920 world, DirectionalFluid fluid, float fluidHeight, float fluidHeightX, float fluidHeightY, class_2338 blockPos) {
        if (!(fluidHeightY >= 1.0f) && !(fluidHeightX >= 1.0f)) {
            float[] fs = new float[2];
            if (fluidHeightY > 0.0f || fluidHeightX > 0.0f) {
                float i = UpsideDownFluidRenderer.getFluidHeight(world, fluid, blockPos);
                if (i >= 1.0f) {
                    return 1.0f;
                }
                UpsideDownFluidRenderer.offsetHeight(fs, i);
            }
            UpsideDownFluidRenderer.offsetHeight(fs, fluidHeight);
            UpsideDownFluidRenderer.offsetHeight(fs, fluidHeightY);
            UpsideDownFluidRenderer.offsetHeight(fs, fluidHeightX);
            return fs[0] / fs[1];
        }
        return 1.0f;
    }

    public static void offsetHeight(float[] fs, float f) {
        if (f >= 0.8f) {
            fs[0] = fs[0] + f * 10.0f;
            fs[1] = fs[1] + 10.0f;
        } else if (f >= 0.0f) {
            fs[0] = fs[0] + f;
            fs[1] = fs[1] + 1.0f;
        }
    }

    public static float getFluidHeight(class_1920 blockRenderView, DirectionalFluid fluid, class_2338 blockPos, class_2680 blockState, class_3610 fluidState) {
        if (fluid.method_15780(fluidState.method_15772())) {
            class_2680 blockState2 = blockRenderView.method_8320(blockPos.method_10093(fluid.getFlowDirection().method_10153()));
            return fluid.method_15780(blockState2.method_26227().method_15772()) ? 1.0f : fluidState.method_20785();
        }
        return !blockState.method_51367() ? 0.0f : -1.0f;
    }

    public static int getLight(class_1920 world, class_2338 pos) {
        int i = class_761.method_23794((class_1920)world, (class_2338)pos);
        int j = class_761.method_23794((class_1920)world, (class_2338)pos.method_10084());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int m = i >> 16 & 0xFF;
        int n = j >> 16 & 0xFF;
        return (k > l ? k : l) | (m > n ? m : n) << 16;
    }

    private void vertex(class_4588 vertexConsumer, double x, double y, double z, float red, float green, float blue, float u, float v, int light) {
        vertexConsumer.method_22912(x, y, z).method_22915(red, green, blue, 1.0f).method_22913(u, v).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }

    private static boolean isSideCovered(class_1922 world, class_2350 direction, float f, class_2338 pos, class_2680 state) {
        if (state.method_26225()) {
            class_265 voxelShape = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)f, (double)1.0);
            class_265 voxelShape2 = state.method_26201(world, pos);
            return class_259.method_1083((class_265)voxelShape, (class_265)voxelShape2, (class_2350)direction);
        }
        return false;
    }

    public static boolean isSideCovered(class_1922 blockView, class_2338 blockPos, class_2350 direction, float maxDeviation, class_2680 blockState) {
        return UpsideDownFluidRenderer.isSideCovered(blockView, direction, maxDeviation, blockPos.method_10093(direction), blockState);
    }

    private static boolean isOppositeSideCovered(class_1922 world, class_2338 pos, class_2680 state, class_2350 direction) {
        return UpsideDownFluidRenderer.isSideCovered(world, direction.method_10153(), 1.0f, pos, state);
    }
}

